<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAssignmentsTable extends Migration
{
    public function up()
    {
        Schema::create('assignments', function (Blueprint $table) {
            $table->id('Assignment_id')->unsignedBigInteger();
            $table->unsignedBigInteger('Lesson_id');
            $table->unsignedBigInteger('User_id');
            $table->string('Title', 255)->notNullable();
            $table->text('Description')->notNullable();
            $table->timestamp('Submitted_at')->nullable();
            $table->enum('Status', ['pending', 'submitted', 'graded'])->default('pending');
            $table->decimal('Grade', 5, 2)->nullable();
            $table->foreign('Lesson_id')->references('Lesson_id')->on('lessons')->onDelete('cascade');
            $table->foreign('User_id')->references('User_id')->on('users')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('assignments');
    }
}
